package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class PurchaseOrderNumberSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String purchaseOrderNumber;

  private String oldPurchaseOrderNumber;

  private String type;

  public PurchaseOrderNumberSet() {
  }

  public PurchaseOrderNumberSet(String purchaseOrderNumber, String oldPurchaseOrderNumber,
      String type) {
    this.purchaseOrderNumber = purchaseOrderNumber;
    this.oldPurchaseOrderNumber = oldPurchaseOrderNumber;
    this.type = type;
  }

  public String getPurchaseOrderNumber() {
    return purchaseOrderNumber;
  }

  public void setPurchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  public String getOldPurchaseOrderNumber() {
    return oldPurchaseOrderNumber;
  }

  public void setOldPurchaseOrderNumber(String oldPurchaseOrderNumber) {
    this.oldPurchaseOrderNumber = oldPurchaseOrderNumber;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "PurchaseOrderNumberSet{purchaseOrderNumber='" + purchaseOrderNumber + "', oldPurchaseOrderNumber='" + oldPurchaseOrderNumber + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PurchaseOrderNumberSet that = (PurchaseOrderNumberSet) o;
    return Objects.equals(purchaseOrderNumber, that.purchaseOrderNumber) &&
        Objects.equals(oldPurchaseOrderNumber, that.oldPurchaseOrderNumber) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purchaseOrderNumber, oldPurchaseOrderNumber, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String purchaseOrderNumber;

    private String oldPurchaseOrderNumber;

    private String type;

    public PurchaseOrderNumberSet build() {
      PurchaseOrderNumberSet result = new PurchaseOrderNumberSet();
      result.purchaseOrderNumber = this.purchaseOrderNumber;
      result.oldPurchaseOrderNumber = this.oldPurchaseOrderNumber;
      result.type = this.type;
      return result;
    }

    public Builder purchaseOrderNumber(String purchaseOrderNumber) {
      this.purchaseOrderNumber = purchaseOrderNumber;
      return this;
    }

    public Builder oldPurchaseOrderNumber(String oldPurchaseOrderNumber) {
      this.oldPurchaseOrderNumber = oldPurchaseOrderNumber;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
