package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class QueryLimitsProjection {
  private Limit offset;

  public QueryLimitsProjection() {
  }

  public QueryLimitsProjection(Limit offset) {
    this.offset = offset;
  }

  public Limit getOffset() {
    return offset;
  }

  public void setOffset(Limit offset) {
    this.offset = offset;
  }

  @Override
  public String toString() {
    return "QueryLimitsProjection{offset='" + offset + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QueryLimitsProjection that = (QueryLimitsProjection) o;
    return Objects.equals(offset, that.offset);
  }

  @Override
  public int hashCode() {
    return Objects.hash(offset);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Limit offset;

    public QueryLimitsProjection build() {
      QueryLimitsProjection result = new QueryLimitsProjection();
      result.offset = this.offset;
      return result;
    }

    public Builder offset(Limit offset) {
      this.offset = offset;
      return this;
    }
  }
}
