package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Quote implements com.commercetools.graphql.api.types.Versioned {
  private Reference customerRef;

  private Customer customer;

  private Reference customerGroupRef;

  private CustomerGroup customerGroup;

  private List<LineItem> lineItems;

  private List<CustomLineItem> customLineItems;

  private Money totalPrice;

  private TaxedPrice taxedPrice;

  private Address shippingAddress;

  private Address billingAddress;

  private List<Address> itemShippingAddresses;

  private InventoryMode inventoryMode;

  private TaxMode taxMode;

  private RoundingMode taxRoundingMode;

  private TaxCalculationMode taxCalculationMode;

  private String country;

  private ShippingInfo shippingInfo;

  private PaymentInfo paymentInfo;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private List<DirectDiscount> directDiscounts;

  private ShippingRateInput shippingRateInput;

  private KeyReference storeRef;

  private Store store;

  private BusinessUnit businessUnit;

  private KeyReference businessUnitRef;

  private String key;

  private QuoteState quoteState;

  private Reference stagedQuoteRef;

  private StagedQuote stagedQuote;

  private Reference quoteRequestRef;

  private QuoteRequest quoteRequest;

  private OffsetDateTime validTo;

  private String sellerComment;

  private String buyerComment;

  private CustomFieldsType custom;

  private Reference stateRef;

  private State state;

  private String purchaseOrderNumber;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public Quote() {
  }

  public Quote(Reference customerRef, Customer customer, Reference customerGroupRef,
      CustomerGroup customerGroup, List<LineItem> lineItems, List<CustomLineItem> customLineItems,
      Money totalPrice, TaxedPrice taxedPrice, Address shippingAddress, Address billingAddress,
      List<Address> itemShippingAddresses, InventoryMode inventoryMode, TaxMode taxMode,
      RoundingMode taxRoundingMode, TaxCalculationMode taxCalculationMode, String country,
      ShippingInfo shippingInfo, PaymentInfo paymentInfo, List<DirectDiscount> directDiscounts,
      ShippingRateInput shippingRateInput, KeyReference storeRef, Store store,
      BusinessUnit businessUnit, KeyReference businessUnitRef, String key, QuoteState quoteState,
      Reference stagedQuoteRef, StagedQuote stagedQuote, Reference quoteRequestRef,
      QuoteRequest quoteRequest, OffsetDateTime validTo, String sellerComment, String buyerComment,
      CustomFieldsType custom, Reference stateRef, State state, String purchaseOrderNumber,
      String id, Long version, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt,
      Initiator createdBy, Initiator lastModifiedBy) {
    this.customerRef = customerRef;
    this.customer = customer;
    this.customerGroupRef = customerGroupRef;
    this.customerGroup = customerGroup;
    this.lineItems = lineItems;
    this.customLineItems = customLineItems;
    this.totalPrice = totalPrice;
    this.taxedPrice = taxedPrice;
    this.shippingAddress = shippingAddress;
    this.billingAddress = billingAddress;
    this.itemShippingAddresses = itemShippingAddresses;
    this.inventoryMode = inventoryMode;
    this.taxMode = taxMode;
    this.taxRoundingMode = taxRoundingMode;
    this.taxCalculationMode = taxCalculationMode;
    this.country = country;
    this.shippingInfo = shippingInfo;
    this.paymentInfo = paymentInfo;
    this.directDiscounts = directDiscounts;
    this.shippingRateInput = shippingRateInput;
    this.storeRef = storeRef;
    this.store = store;
    this.businessUnit = businessUnit;
    this.businessUnitRef = businessUnitRef;
    this.key = key;
    this.quoteState = quoteState;
    this.stagedQuoteRef = stagedQuoteRef;
    this.stagedQuote = stagedQuote;
    this.quoteRequestRef = quoteRequestRef;
    this.quoteRequest = quoteRequest;
    this.validTo = validTo;
    this.sellerComment = sellerComment;
    this.buyerComment = buyerComment;
    this.custom = custom;
    this.stateRef = stateRef;
    this.state = state;
    this.purchaseOrderNumber = purchaseOrderNumber;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public Reference getCustomerRef() {
    return customerRef;
  }

  public void setCustomerRef(Reference customerRef) {
    this.customerRef = customerRef;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public Reference getCustomerGroupRef() {
    return customerGroupRef;
  }

  public void setCustomerGroupRef(Reference customerGroupRef) {
    this.customerGroupRef = customerGroupRef;
  }

  public CustomerGroup getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(CustomerGroup customerGroup) {
    this.customerGroup = customerGroup;
  }

  public List<LineItem> getLineItems() {
    return lineItems;
  }

  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }

  public List<CustomLineItem> getCustomLineItems() {
    return customLineItems;
  }

  public void setCustomLineItems(List<CustomLineItem> customLineItems) {
    this.customLineItems = customLineItems;
  }

  public Money getTotalPrice() {
    return totalPrice;
  }

  public void setTotalPrice(Money totalPrice) {
    this.totalPrice = totalPrice;
  }

  public TaxedPrice getTaxedPrice() {
    return taxedPrice;
  }

  public void setTaxedPrice(TaxedPrice taxedPrice) {
    this.taxedPrice = taxedPrice;
  }

  public Address getShippingAddress() {
    return shippingAddress;
  }

  public void setShippingAddress(Address shippingAddress) {
    this.shippingAddress = shippingAddress;
  }

  public Address getBillingAddress() {
    return billingAddress;
  }

  public void setBillingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
  }

  public List<Address> getItemShippingAddresses() {
    return itemShippingAddresses;
  }

  public void setItemShippingAddresses(List<Address> itemShippingAddresses) {
    this.itemShippingAddresses = itemShippingAddresses;
  }

  public InventoryMode getInventoryMode() {
    return inventoryMode;
  }

  public void setInventoryMode(InventoryMode inventoryMode) {
    this.inventoryMode = inventoryMode;
  }

  public TaxMode getTaxMode() {
    return taxMode;
  }

  public void setTaxMode(TaxMode taxMode) {
    this.taxMode = taxMode;
  }

  public RoundingMode getTaxRoundingMode() {
    return taxRoundingMode;
  }

  public void setTaxRoundingMode(RoundingMode taxRoundingMode) {
    this.taxRoundingMode = taxRoundingMode;
  }

  public TaxCalculationMode getTaxCalculationMode() {
    return taxCalculationMode;
  }

  public void setTaxCalculationMode(TaxCalculationMode taxCalculationMode) {
    this.taxCalculationMode = taxCalculationMode;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public ShippingInfo getShippingInfo() {
    return shippingInfo;
  }

  public void setShippingInfo(ShippingInfo shippingInfo) {
    this.shippingInfo = shippingInfo;
  }

  public PaymentInfo getPaymentInfo() {
    return paymentInfo;
  }

  public void setPaymentInfo(PaymentInfo paymentInfo) {
    this.paymentInfo = paymentInfo;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public List<DirectDiscount> getDirectDiscounts() {
    return directDiscounts;
  }

  public void setDirectDiscounts(List<DirectDiscount> directDiscounts) {
    this.directDiscounts = directDiscounts;
  }

  public ShippingRateInput getShippingRateInput() {
    return shippingRateInput;
  }

  public void setShippingRateInput(ShippingRateInput shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Store getStore() {
    return store;
  }

  public void setStore(Store store) {
    this.store = store;
  }

  public BusinessUnit getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(BusinessUnit businessUnit) {
    this.businessUnit = businessUnit;
  }

  public KeyReference getBusinessUnitRef() {
    return businessUnitRef;
  }

  public void setBusinessUnitRef(KeyReference businessUnitRef) {
    this.businessUnitRef = businessUnitRef;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public QuoteState getQuoteState() {
    return quoteState;
  }

  public void setQuoteState(QuoteState quoteState) {
    this.quoteState = quoteState;
  }

  public Reference getStagedQuoteRef() {
    return stagedQuoteRef;
  }

  public void setStagedQuoteRef(Reference stagedQuoteRef) {
    this.stagedQuoteRef = stagedQuoteRef;
  }

  public StagedQuote getStagedQuote() {
    return stagedQuote;
  }

  public void setStagedQuote(StagedQuote stagedQuote) {
    this.stagedQuote = stagedQuote;
  }

  public Reference getQuoteRequestRef() {
    return quoteRequestRef;
  }

  public void setQuoteRequestRef(Reference quoteRequestRef) {
    this.quoteRequestRef = quoteRequestRef;
  }

  public QuoteRequest getQuoteRequest() {
    return quoteRequest;
  }

  public void setQuoteRequest(QuoteRequest quoteRequest) {
    this.quoteRequest = quoteRequest;
  }

  public OffsetDateTime getValidTo() {
    return validTo;
  }

  public void setValidTo(OffsetDateTime validTo) {
    this.validTo = validTo;
  }

  public String getSellerComment() {
    return sellerComment;
  }

  public void setSellerComment(String sellerComment) {
    this.sellerComment = sellerComment;
  }

  public String getBuyerComment() {
    return buyerComment;
  }

  public void setBuyerComment(String buyerComment) {
    this.buyerComment = buyerComment;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public Reference getStateRef() {
    return stateRef;
  }

  public void setStateRef(Reference stateRef) {
    this.stateRef = stateRef;
  }

  public State getState() {
    return state;
  }

  public void setState(State state) {
    this.state = state;
  }

  public String getPurchaseOrderNumber() {
    return purchaseOrderNumber;
  }

  public void setPurchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "Quote{customerRef='" + customerRef + "', customer='" + customer + "', customerGroupRef='" + customerGroupRef + "', customerGroup='" + customerGroup + "', lineItems='" + lineItems + "', customLineItems='" + customLineItems + "', totalPrice='" + totalPrice + "', taxedPrice='" + taxedPrice + "', shippingAddress='" + shippingAddress + "', billingAddress='" + billingAddress + "', itemShippingAddresses='" + itemShippingAddresses + "', inventoryMode='" + inventoryMode + "', taxMode='" + taxMode + "', taxRoundingMode='" + taxRoundingMode + "', taxCalculationMode='" + taxCalculationMode + "', country='" + country + "', shippingInfo='" + shippingInfo + "', paymentInfo='" + paymentInfo + "', directDiscounts='" + directDiscounts + "', shippingRateInput='" + shippingRateInput + "', storeRef='" + storeRef + "', store='" + store + "', businessUnit='" + businessUnit + "', businessUnitRef='" + businessUnitRef + "', key='" + key + "', quoteState='" + quoteState + "', stagedQuoteRef='" + stagedQuoteRef + "', stagedQuote='" + stagedQuote + "', quoteRequestRef='" + quoteRequestRef + "', quoteRequest='" + quoteRequest + "', validTo='" + validTo + "', sellerComment='" + sellerComment + "', buyerComment='" + buyerComment + "', custom='" + custom + "', stateRef='" + stateRef + "', state='" + state + "', purchaseOrderNumber='" + purchaseOrderNumber + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Quote that = (Quote) o;
    return Objects.equals(customerRef, that.customerRef) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(customerGroupRef, that.customerGroupRef) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(lineItems, that.lineItems) &&
        Objects.equals(customLineItems, that.customLineItems) &&
        Objects.equals(totalPrice, that.totalPrice) &&
        Objects.equals(taxedPrice, that.taxedPrice) &&
        Objects.equals(shippingAddress, that.shippingAddress) &&
        Objects.equals(billingAddress, that.billingAddress) &&
        Objects.equals(itemShippingAddresses, that.itemShippingAddresses) &&
        Objects.equals(inventoryMode, that.inventoryMode) &&
        Objects.equals(taxMode, that.taxMode) &&
        Objects.equals(taxRoundingMode, that.taxRoundingMode) &&
        Objects.equals(taxCalculationMode, that.taxCalculationMode) &&
        Objects.equals(country, that.country) &&
        Objects.equals(shippingInfo, that.shippingInfo) &&
        Objects.equals(paymentInfo, that.paymentInfo) &&
        Objects.equals(directDiscounts, that.directDiscounts) &&
        Objects.equals(shippingRateInput, that.shippingRateInput) &&
        Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(store, that.store) &&
        Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(businessUnitRef, that.businessUnitRef) &&
        Objects.equals(key, that.key) &&
        Objects.equals(quoteState, that.quoteState) &&
        Objects.equals(stagedQuoteRef, that.stagedQuoteRef) &&
        Objects.equals(stagedQuote, that.stagedQuote) &&
        Objects.equals(quoteRequestRef, that.quoteRequestRef) &&
        Objects.equals(quoteRequest, that.quoteRequest) &&
        Objects.equals(validTo, that.validTo) &&
        Objects.equals(sellerComment, that.sellerComment) &&
        Objects.equals(buyerComment, that.buyerComment) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(stateRef, that.stateRef) &&
        Objects.equals(state, that.state) &&
        Objects.equals(purchaseOrderNumber, that.purchaseOrderNumber) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerRef, customer, customerGroupRef, customerGroup, lineItems, customLineItems, totalPrice, taxedPrice, shippingAddress, billingAddress, itemShippingAddresses, inventoryMode, taxMode, taxRoundingMode, taxCalculationMode, country, shippingInfo, paymentInfo, directDiscounts, shippingRateInput, storeRef, store, businessUnit, businessUnitRef, key, quoteState, stagedQuoteRef, stagedQuote, quoteRequestRef, quoteRequest, validTo, sellerComment, buyerComment, custom, stateRef, state, purchaseOrderNumber, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference customerRef;

    private Customer customer;

    private Reference customerGroupRef;

    private CustomerGroup customerGroup;

    private List<LineItem> lineItems;

    private List<CustomLineItem> customLineItems;

    private Money totalPrice;

    private TaxedPrice taxedPrice;

    private Address shippingAddress;

    private Address billingAddress;

    private List<Address> itemShippingAddresses;

    private InventoryMode inventoryMode;

    private TaxMode taxMode;

    private RoundingMode taxRoundingMode;

    private TaxCalculationMode taxCalculationMode;

    private String country;

    private ShippingInfo shippingInfo;

    private PaymentInfo paymentInfo;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private List<DirectDiscount> directDiscounts;

    private ShippingRateInput shippingRateInput;

    private KeyReference storeRef;

    private Store store;

    private BusinessUnit businessUnit;

    private KeyReference businessUnitRef;

    private String key;

    private QuoteState quoteState;

    private Reference stagedQuoteRef;

    private StagedQuote stagedQuote;

    private Reference quoteRequestRef;

    private QuoteRequest quoteRequest;

    private OffsetDateTime validTo;

    private String sellerComment;

    private String buyerComment;

    private CustomFieldsType custom;

    private Reference stateRef;

    private State state;

    private String purchaseOrderNumber;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public Quote build() {
      Quote result = new Quote();
      result.customerRef = this.customerRef;
      result.customer = this.customer;
      result.customerGroupRef = this.customerGroupRef;
      result.customerGroup = this.customerGroup;
      result.lineItems = this.lineItems;
      result.customLineItems = this.customLineItems;
      result.totalPrice = this.totalPrice;
      result.taxedPrice = this.taxedPrice;
      result.shippingAddress = this.shippingAddress;
      result.billingAddress = this.billingAddress;
      result.itemShippingAddresses = this.itemShippingAddresses;
      result.inventoryMode = this.inventoryMode;
      result.taxMode = this.taxMode;
      result.taxRoundingMode = this.taxRoundingMode;
      result.taxCalculationMode = this.taxCalculationMode;
      result.country = this.country;
      result.shippingInfo = this.shippingInfo;
      result.paymentInfo = this.paymentInfo;
      result.directDiscounts = this.directDiscounts;
      result.shippingRateInput = this.shippingRateInput;
      result.storeRef = this.storeRef;
      result.store = this.store;
      result.businessUnit = this.businessUnit;
      result.businessUnitRef = this.businessUnitRef;
      result.key = this.key;
      result.quoteState = this.quoteState;
      result.stagedQuoteRef = this.stagedQuoteRef;
      result.stagedQuote = this.stagedQuote;
      result.quoteRequestRef = this.quoteRequestRef;
      result.quoteRequest = this.quoteRequest;
      result.validTo = this.validTo;
      result.sellerComment = this.sellerComment;
      result.buyerComment = this.buyerComment;
      result.custom = this.custom;
      result.stateRef = this.stateRef;
      result.state = this.state;
      result.purchaseOrderNumber = this.purchaseOrderNumber;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder customerRef(Reference customerRef) {
      this.customerRef = customerRef;
      return this;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder customerGroupRef(Reference customerGroupRef) {
      this.customerGroupRef = customerGroupRef;
      return this;
    }

    public Builder customerGroup(CustomerGroup customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder lineItems(List<LineItem> lineItems) {
      this.lineItems = lineItems;
      return this;
    }

    public Builder customLineItems(List<CustomLineItem> customLineItems) {
      this.customLineItems = customLineItems;
      return this;
    }

    public Builder totalPrice(Money totalPrice) {
      this.totalPrice = totalPrice;
      return this;
    }

    public Builder taxedPrice(TaxedPrice taxedPrice) {
      this.taxedPrice = taxedPrice;
      return this;
    }

    public Builder shippingAddress(Address shippingAddress) {
      this.shippingAddress = shippingAddress;
      return this;
    }

    public Builder billingAddress(Address billingAddress) {
      this.billingAddress = billingAddress;
      return this;
    }

    public Builder itemShippingAddresses(List<Address> itemShippingAddresses) {
      this.itemShippingAddresses = itemShippingAddresses;
      return this;
    }

    public Builder inventoryMode(InventoryMode inventoryMode) {
      this.inventoryMode = inventoryMode;
      return this;
    }

    public Builder taxMode(TaxMode taxMode) {
      this.taxMode = taxMode;
      return this;
    }

    public Builder taxRoundingMode(RoundingMode taxRoundingMode) {
      this.taxRoundingMode = taxRoundingMode;
      return this;
    }

    public Builder taxCalculationMode(TaxCalculationMode taxCalculationMode) {
      this.taxCalculationMode = taxCalculationMode;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder shippingInfo(ShippingInfo shippingInfo) {
      this.shippingInfo = shippingInfo;
      return this;
    }

    public Builder paymentInfo(PaymentInfo paymentInfo) {
      this.paymentInfo = paymentInfo;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder directDiscounts(List<DirectDiscount> directDiscounts) {
      this.directDiscounts = directDiscounts;
      return this;
    }

    public Builder shippingRateInput(ShippingRateInput shippingRateInput) {
      this.shippingRateInput = shippingRateInput;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder store(Store store) {
      this.store = store;
      return this;
    }

    public Builder businessUnit(BusinessUnit businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder businessUnitRef(KeyReference businessUnitRef) {
      this.businessUnitRef = businessUnitRef;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder quoteState(QuoteState quoteState) {
      this.quoteState = quoteState;
      return this;
    }

    public Builder stagedQuoteRef(Reference stagedQuoteRef) {
      this.stagedQuoteRef = stagedQuoteRef;
      return this;
    }

    public Builder stagedQuote(StagedQuote stagedQuote) {
      this.stagedQuote = stagedQuote;
      return this;
    }

    public Builder quoteRequestRef(Reference quoteRequestRef) {
      this.quoteRequestRef = quoteRequestRef;
      return this;
    }

    public Builder quoteRequest(QuoteRequest quoteRequest) {
      this.quoteRequest = quoteRequest;
      return this;
    }

    public Builder validTo(OffsetDateTime validTo) {
      this.validTo = validTo;
      return this;
    }

    public Builder sellerComment(String sellerComment) {
      this.sellerComment = sellerComment;
      return this;
    }

    public Builder buyerComment(String buyerComment) {
      this.buyerComment = buyerComment;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder stateRef(Reference stateRef) {
      this.stateRef = stateRef;
      return this;
    }

    public Builder state(State state) {
      this.state = state;
      return this;
    }

    public Builder purchaseOrderNumber(String purchaseOrderNumber) {
      this.purchaseOrderNumber = purchaseOrderNumber;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
