package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class QuoteCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private Quote quote;

  private String type;

  public QuoteCreated() {
  }

  public QuoteCreated(Quote quote, String type) {
    this.quote = quote;
    this.type = type;
  }

  public Quote getQuote() {
    return quote;
  }

  public void setQuote(Quote quote) {
    this.quote = quote;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "QuoteCreated{quote='" + quote + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QuoteCreated that = (QuoteCreated) o;
    return Objects.equals(quote, that.quote) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quote, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Quote quote;

    private String type;

    public QuoteCreated build() {
      QuoteCreated result = new QuoteCreated();
      result.quote = this.quote;
      result.type = this.type;
      return result;
    }

    public Builder quote(Quote quote) {
      this.quote = quote;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
