package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class QuoteDraft {
  private String key;

  private ResourceIdentifierInput stagedQuote;

  private Long stagedQuoteVersion;

  private Boolean stagedQuoteStateToSent = false;

  private CustomFieldsDraft custom;

  private ReferenceInput state;

  public QuoteDraft() {
  }

  public QuoteDraft(String key, ResourceIdentifierInput stagedQuote, Long stagedQuoteVersion,
      Boolean stagedQuoteStateToSent, CustomFieldsDraft custom, ReferenceInput state) {
    this.key = key;
    this.stagedQuote = stagedQuote;
    this.stagedQuoteVersion = stagedQuoteVersion;
    this.stagedQuoteStateToSent = stagedQuoteStateToSent;
    this.custom = custom;
    this.state = state;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ResourceIdentifierInput getStagedQuote() {
    return stagedQuote;
  }

  public void setStagedQuote(ResourceIdentifierInput stagedQuote) {
    this.stagedQuote = stagedQuote;
  }

  public Long getStagedQuoteVersion() {
    return stagedQuoteVersion;
  }

  public void setStagedQuoteVersion(Long stagedQuoteVersion) {
    this.stagedQuoteVersion = stagedQuoteVersion;
  }

  public Boolean getStagedQuoteStateToSent() {
    return stagedQuoteStateToSent;
  }

  public void setStagedQuoteStateToSent(Boolean stagedQuoteStateToSent) {
    this.stagedQuoteStateToSent = stagedQuoteStateToSent;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public ReferenceInput getState() {
    return state;
  }

  public void setState(ReferenceInput state) {
    this.state = state;
  }

  @Override
  public String toString() {
    return "QuoteDraft{key='" + key + "', stagedQuote='" + stagedQuote + "', stagedQuoteVersion='" + stagedQuoteVersion + "', stagedQuoteStateToSent='" + stagedQuoteStateToSent + "', custom='" + custom + "', state='" + state + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QuoteDraft that = (QuoteDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(stagedQuote, that.stagedQuote) &&
        Objects.equals(stagedQuoteVersion, that.stagedQuoteVersion) &&
        Objects.equals(stagedQuoteStateToSent, that.stagedQuoteStateToSent) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(state, that.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, stagedQuote, stagedQuoteVersion, stagedQuoteStateToSent, custom, state);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private ResourceIdentifierInput stagedQuote;

    private Long stagedQuoteVersion;

    private Boolean stagedQuoteStateToSent = false;

    private CustomFieldsDraft custom;

    private ReferenceInput state;

    public QuoteDraft build() {
      QuoteDraft result = new QuoteDraft();
      result.key = this.key;
      result.stagedQuote = this.stagedQuote;
      result.stagedQuoteVersion = this.stagedQuoteVersion;
      result.stagedQuoteStateToSent = this.stagedQuoteStateToSent;
      result.custom = this.custom;
      result.state = this.state;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder stagedQuote(ResourceIdentifierInput stagedQuote) {
      this.stagedQuote = stagedQuote;
      return this;
    }

    public Builder stagedQuoteVersion(Long stagedQuoteVersion) {
      this.stagedQuoteVersion = stagedQuoteVersion;
      return this;
    }

    public Builder stagedQuoteStateToSent(Boolean stagedQuoteStateToSent) {
      this.stagedQuoteStateToSent = stagedQuoteStateToSent;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder state(ReferenceInput state) {
      this.state = state;
      return this;
    }
  }
}
