package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * Fields to access Quotes.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes(@JsonSubTypes.Type(value = AsAssociate.class, name = "AsAssociate"))
public interface QuoteQueryInterface {
  Quote getQuote();

  void setQuote(Quote quote);

  QuoteQueryResult getQuotes();

  void setQuotes(QuoteQueryResult quotes);
}
