package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class QuoteRequestStateChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private QuoteRequestState quoteRequestState;

  private QuoteRequestState oldQuoteRequestState;

  private String type;

  public QuoteRequestStateChanged() {
  }

  public QuoteRequestStateChanged(QuoteRequestState quoteRequestState,
      QuoteRequestState oldQuoteRequestState, String type) {
    this.quoteRequestState = quoteRequestState;
    this.oldQuoteRequestState = oldQuoteRequestState;
    this.type = type;
  }

  public QuoteRequestState getQuoteRequestState() {
    return quoteRequestState;
  }

  public void setQuoteRequestState(QuoteRequestState quoteRequestState) {
    this.quoteRequestState = quoteRequestState;
  }

  public QuoteRequestState getOldQuoteRequestState() {
    return oldQuoteRequestState;
  }

  public void setOldQuoteRequestState(QuoteRequestState oldQuoteRequestState) {
    this.oldQuoteRequestState = oldQuoteRequestState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "QuoteRequestStateChanged{quoteRequestState='" + quoteRequestState + "', oldQuoteRequestState='" + oldQuoteRequestState + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QuoteRequestStateChanged that = (QuoteRequestStateChanged) o;
    return Objects.equals(quoteRequestState, that.quoteRequestState) &&
        Objects.equals(oldQuoteRequestState, that.oldQuoteRequestState) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quoteRequestState, oldQuoteRequestState, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private QuoteRequestState quoteRequestState;

    private QuoteRequestState oldQuoteRequestState;

    private String type;

    public QuoteRequestStateChanged build() {
      QuoteRequestStateChanged result = new QuoteRequestStateChanged();
      result.quoteRequestState = this.quoteRequestState;
      result.oldQuoteRequestState = this.oldQuoteRequestState;
      result.type = this.type;
      return result;
    }

    public Builder quoteRequestState(QuoteRequestState quoteRequestState) {
      this.quoteRequestState = quoteRequestState;
      return this;
    }

    public Builder oldQuoteRequestState(QuoteRequestState oldQuoteRequestState) {
      this.oldQuoteRequestState = oldQuoteRequestState;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
