package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class QuoteRequestStateTransition implements com.commercetools.graphql.api.types.MessagePayload {
  private Reference stateRef;

  private Reference oldStateRef;

  private Boolean force;

  private State state;

  private State oldState;

  private String type;

  public QuoteRequestStateTransition() {
  }

  public QuoteRequestStateTransition(Reference stateRef, Reference oldStateRef, Boolean force,
      State state, State oldState, String type) {
    this.stateRef = stateRef;
    this.oldStateRef = oldStateRef;
    this.force = force;
    this.state = state;
    this.oldState = oldState;
    this.type = type;
  }

  public Reference getStateRef() {
    return stateRef;
  }

  public void setStateRef(Reference stateRef) {
    this.stateRef = stateRef;
  }

  public Reference getOldStateRef() {
    return oldStateRef;
  }

  public void setOldStateRef(Reference oldStateRef) {
    this.oldStateRef = oldStateRef;
  }

  public Boolean getForce() {
    return force;
  }

  public void setForce(Boolean force) {
    this.force = force;
  }

  public State getState() {
    return state;
  }

  public void setState(State state) {
    this.state = state;
  }

  public State getOldState() {
    return oldState;
  }

  public void setOldState(State oldState) {
    this.oldState = oldState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "QuoteRequestStateTransition{stateRef='" + stateRef + "', oldStateRef='" + oldStateRef + "', force='" + force + "', state='" + state + "', oldState='" + oldState + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QuoteRequestStateTransition that = (QuoteRequestStateTransition) o;
    return Objects.equals(stateRef, that.stateRef) &&
        Objects.equals(oldStateRef, that.oldStateRef) &&
        Objects.equals(force, that.force) &&
        Objects.equals(state, that.state) &&
        Objects.equals(oldState, that.oldState) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stateRef, oldStateRef, force, state, oldState, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference stateRef;

    private Reference oldStateRef;

    private Boolean force;

    private State state;

    private State oldState;

    private String type;

    public QuoteRequestStateTransition build() {
      QuoteRequestStateTransition result = new QuoteRequestStateTransition();
      result.stateRef = this.stateRef;
      result.oldStateRef = this.oldStateRef;
      result.force = this.force;
      result.state = this.state;
      result.oldState = this.oldState;
      result.type = this.type;
      return result;
    }

    public Builder stateRef(Reference stateRef) {
      this.stateRef = stateRef;
      return this;
    }

    public Builder oldStateRef(Reference oldStateRef) {
      this.oldStateRef = oldStateRef;
      return this;
    }

    public Builder force(Boolean force) {
      this.force = force;
      return this;
    }

    public Builder state(State state) {
      this.state = state;
      return this;
    }

    public Builder oldState(State oldState) {
      this.oldState = oldState;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
