package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class QuoteRequestUpdateAction {
  private ChangeQuoteRequestCustomer changeCustomer;

  private ChangeQuoteRequestState changeQuoteRequestState;

  private SetQuoteRequestCustomField setCustomField;

  private SetQuoteRequestCustomType setCustomType;

  private TransitionQuoteRequestState transitionState;

  public QuoteRequestUpdateAction() {
  }

  public QuoteRequestUpdateAction(ChangeQuoteRequestCustomer changeCustomer,
      ChangeQuoteRequestState changeQuoteRequestState, SetQuoteRequestCustomField setCustomField,
      SetQuoteRequestCustomType setCustomType, TransitionQuoteRequestState transitionState) {
    this.changeCustomer = changeCustomer;
    this.changeQuoteRequestState = changeQuoteRequestState;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.transitionState = transitionState;
  }

  public ChangeQuoteRequestCustomer getChangeCustomer() {
    return changeCustomer;
  }

  public void setChangeCustomer(ChangeQuoteRequestCustomer changeCustomer) {
    this.changeCustomer = changeCustomer;
  }

  public ChangeQuoteRequestState getChangeQuoteRequestState() {
    return changeQuoteRequestState;
  }

  public void setChangeQuoteRequestState(ChangeQuoteRequestState changeQuoteRequestState) {
    this.changeQuoteRequestState = changeQuoteRequestState;
  }

  public SetQuoteRequestCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetQuoteRequestCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetQuoteRequestCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetQuoteRequestCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public TransitionQuoteRequestState getTransitionState() {
    return transitionState;
  }

  public void setTransitionState(TransitionQuoteRequestState transitionState) {
    this.transitionState = transitionState;
  }

  @Override
  public String toString() {
    return "QuoteRequestUpdateAction{changeCustomer='" + changeCustomer + "', changeQuoteRequestState='" + changeQuoteRequestState + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', transitionState='" + transitionState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QuoteRequestUpdateAction that = (QuoteRequestUpdateAction) o;
    return Objects.equals(changeCustomer, that.changeCustomer) &&
        Objects.equals(changeQuoteRequestState, that.changeQuoteRequestState) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(transitionState, that.transitionState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeCustomer, changeQuoteRequestState, setCustomField, setCustomType, transitionState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ChangeQuoteRequestCustomer changeCustomer;

    private ChangeQuoteRequestState changeQuoteRequestState;

    private SetQuoteRequestCustomField setCustomField;

    private SetQuoteRequestCustomType setCustomType;

    private TransitionQuoteRequestState transitionState;

    public QuoteRequestUpdateAction build() {
      QuoteRequestUpdateAction result = new QuoteRequestUpdateAction();
      result.changeCustomer = this.changeCustomer;
      result.changeQuoteRequestState = this.changeQuoteRequestState;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.transitionState = this.transitionState;
      return result;
    }

    public Builder changeCustomer(ChangeQuoteRequestCustomer changeCustomer) {
      this.changeCustomer = changeCustomer;
      return this;
    }

    public Builder changeQuoteRequestState(ChangeQuoteRequestState changeQuoteRequestState) {
      this.changeQuoteRequestState = changeQuoteRequestState;
      return this;
    }

    public Builder setCustomField(SetQuoteRequestCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetQuoteRequestCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder transitionState(TransitionQuoteRequestState transitionState) {
      this.transitionState = transitionState;
      return this;
    }
  }
}
