package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class RangeFacetResult implements com.commercetools.graphql.api.types.FacetResult {
  private String dataType;

  private List<RangeCount> ranges;

  private String type;

  public RangeFacetResult() {
  }

  public RangeFacetResult(String dataType, List<RangeCount> ranges, String type) {
    this.dataType = dataType;
    this.ranges = ranges;
    this.type = type;
  }

  public String getDataType() {
    return dataType;
  }

  public void setDataType(String dataType) {
    this.dataType = dataType;
  }

  public List<RangeCount> getRanges() {
    return ranges;
  }

  public void setRanges(List<RangeCount> ranges) {
    this.ranges = ranges;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "RangeFacetResult{dataType='" + dataType + "', ranges='" + ranges + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RangeFacetResult that = (RangeFacetResult) o;
    return Objects.equals(dataType, that.dataType) &&
        Objects.equals(ranges, that.ranges) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataType, ranges, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String dataType;

    private List<RangeCount> ranges;

    private String type;

    public RangeFacetResult build() {
      RangeFacetResult result = new RangeFacetResult();
      result.dataType = this.dataType;
      result.ranges = this.ranges;
      result.type = this.type;
      return result;
    }

    public Builder dataType(String dataType) {
      this.dataType = dataType;
      return this;
    }

    public Builder ranges(List<RangeCount> ranges) {
      this.ranges = ranges;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
