package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class RangeFilterInput {
  private String path;

  private List<RangeElementInput> ranges;

  public RangeFilterInput() {
  }

  public RangeFilterInput(String path, List<RangeElementInput> ranges) {
    this.path = path;
    this.ranges = ranges;
  }

  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  public List<RangeElementInput> getRanges() {
    return ranges;
  }

  public void setRanges(List<RangeElementInput> ranges) {
    this.ranges = ranges;
  }

  @Override
  public String toString() {
    return "RangeFilterInput{path='" + path + "', ranges='" + ranges + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RangeFilterInput that = (RangeFilterInput) o;
    return Objects.equals(path, that.path) &&
        Objects.equals(ranges, that.ranges);
  }

  @Override
  public int hashCode() {
    return Objects.hash(path, ranges);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String path;

    private List<RangeElementInput> ranges;

    public RangeFilterInput build() {
      RangeFilterInput result = new RangeFilterInput();
      result.path = this.path;
      result.ranges = this.ranges;
      return result;
    }

    public Builder path(String path) {
      this.path = path;
      return this;
    }

    public Builder ranges(List<RangeElementInput> ranges) {
      this.ranges = ranges;
      return this;
    }
  }
}
