package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class RawProductAttribute {
  private String name;

  private JsonNode value;

  private AttributeDefinition attributeDefinition;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private ReferenceExpandable referencedResource;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private List<ReferenceExpandable> referencedResourceSet;

  public RawProductAttribute() {
  }

  public RawProductAttribute(String name, JsonNode value, AttributeDefinition attributeDefinition,
      ReferenceExpandable referencedResource, List<ReferenceExpandable> referencedResourceSet) {
    this.name = name;
    this.value = value;
    this.attributeDefinition = attributeDefinition;
    this.referencedResource = referencedResource;
    this.referencedResourceSet = referencedResourceSet;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  public AttributeDefinition getAttributeDefinition() {
    return attributeDefinition;
  }

  public void setAttributeDefinition(AttributeDefinition attributeDefinition) {
    this.attributeDefinition = attributeDefinition;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public ReferenceExpandable getReferencedResource() {
    return referencedResource;
  }

  public void setReferencedResource(ReferenceExpandable referencedResource) {
    this.referencedResource = referencedResource;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public List<ReferenceExpandable> getReferencedResourceSet() {
    return referencedResourceSet;
  }

  public void setReferencedResourceSet(List<ReferenceExpandable> referencedResourceSet) {
    this.referencedResourceSet = referencedResourceSet;
  }

  @Override
  public String toString() {
    return "RawProductAttribute{name='" + name + "', value='" + value + "', attributeDefinition='" + attributeDefinition + "', referencedResource='" + referencedResource + "', referencedResourceSet='" + referencedResourceSet + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RawProductAttribute that = (RawProductAttribute) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(attributeDefinition, that.attributeDefinition) &&
        Objects.equals(referencedResource, that.referencedResource) &&
        Objects.equals(referencedResourceSet, that.referencedResourceSet);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, value, attributeDefinition, referencedResource, referencedResourceSet);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private JsonNode value;

    private AttributeDefinition attributeDefinition;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private ReferenceExpandable referencedResource;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private List<ReferenceExpandable> referencedResourceSet;

    public RawProductAttribute build() {
      RawProductAttribute result = new RawProductAttribute();
      result.name = this.name;
      result.value = this.value;
      result.attributeDefinition = this.attributeDefinition;
      result.referencedResource = this.referencedResource;
      result.referencedResourceSet = this.referencedResourceSet;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }

    public Builder attributeDefinition(AttributeDefinition attributeDefinition) {
      this.attributeDefinition = attributeDefinition;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder referencedResource(ReferenceExpandable referencedResource) {
      this.referencedResource = referencedResource;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder referencedResourceSet(List<ReferenceExpandable> referencedResourceSet) {
      this.referencedResourceSet = referencedResourceSet;
      return this;
    }
  }
}
