package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class Reference {
  private String typeId;

  private String id;

  public Reference() {
  }

  public Reference(String typeId, String id) {
    this.typeId = typeId;
    this.id = id;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @Override
  public String toString() {
    return "Reference{typeId='" + typeId + "', id='" + id + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Reference that = (Reference) o;
    return Objects.equals(typeId, that.typeId) &&
        Objects.equals(id, that.id);
  }

  @Override
  public int hashCode() {
    return Objects.hash(typeId, id);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String typeId;

    private String id;

    public Reference build() {
      Reference result = new Reference();
      result.typeId = this.typeId;
      result.id = this.id;
      return result;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }
  }
}
