package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ReferenceAttributeDefinitionType implements com.commercetools.graphql.api.types.AttributeDefinitionType {
  private String referenceTypeId;

  private String name;

  public ReferenceAttributeDefinitionType() {
  }

  public ReferenceAttributeDefinitionType(String referenceTypeId, String name) {
    this.referenceTypeId = referenceTypeId;
    this.name = name;
  }

  public String getReferenceTypeId() {
    return referenceTypeId;
  }

  public void setReferenceTypeId(String referenceTypeId) {
    this.referenceTypeId = referenceTypeId;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "ReferenceAttributeDefinitionType{referenceTypeId='" + referenceTypeId + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReferenceAttributeDefinitionType that = (ReferenceAttributeDefinitionType) o;
    return Objects.equals(referenceTypeId, that.referenceTypeId) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(referenceTypeId, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String referenceTypeId;

    private String name;

    public ReferenceAttributeDefinitionType build() {
      ReferenceAttributeDefinitionType result = new ReferenceAttributeDefinitionType();
      result.referenceTypeId = this.referenceTypeId;
      result.name = this.name;
      return result;
    }

    public Builder referenceTypeId(String referenceTypeId) {
      this.referenceTypeId = referenceTypeId;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
