package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ReferenceType implements com.commercetools.graphql.api.types.FieldType {
  private String referenceTypeId;

  private String name;

  public ReferenceType() {
  }

  public ReferenceType(String referenceTypeId, String name) {
    this.referenceTypeId = referenceTypeId;
    this.name = name;
  }

  public String getReferenceTypeId() {
    return referenceTypeId;
  }

  public void setReferenceTypeId(String referenceTypeId) {
    this.referenceTypeId = referenceTypeId;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "ReferenceType{referenceTypeId='" + referenceTypeId + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReferenceType that = (ReferenceType) o;
    return Objects.equals(referenceTypeId, that.referenceTypeId) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(referenceTypeId, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String referenceTypeId;

    private String name;

    public ReferenceType build() {
      ReferenceType result = new ReferenceType();
      result.referenceTypeId = this.referenceTypeId;
      result.name = this.name;
      return result;
    }

    public Builder referenceTypeId(String referenceTypeId) {
      this.referenceTypeId = referenceTypeId;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
