package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RejectApprovalFlow {
  private String reason;

  public RejectApprovalFlow() {
  }

  public RejectApprovalFlow(String reason) {
    this.reason = reason;
  }

  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  @Override
  public String toString() {
    return "RejectApprovalFlow{reason='" + reason + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RejectApprovalFlow that = (RejectApprovalFlow) o;
    return Objects.equals(reason, that.reason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reason);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String reason;

    public RejectApprovalFlow build() {
      RejectApprovalFlow result = new RejectApprovalFlow();
      result.reason = this.reason;
      return result;
    }

    public Builder reason(String reason) {
      this.reason = reason;
      return this;
    }
  }
}
