package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class RelativeDiscountValue implements com.commercetools.graphql.api.types.CartDiscountValue, com.commercetools.graphql.api.types.ProductDiscountValue {
  private Integer permyriad;

  private String type;

  public RelativeDiscountValue() {
  }

  public RelativeDiscountValue(Integer permyriad, String type) {
    this.permyriad = permyriad;
    this.type = type;
  }

  public Integer getPermyriad() {
    return permyriad;
  }

  public void setPermyriad(Integer permyriad) {
    this.permyriad = permyriad;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "RelativeDiscountValue{permyriad='" + permyriad + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RelativeDiscountValue that = (RelativeDiscountValue) o;
    return Objects.equals(permyriad, that.permyriad) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(permyriad, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer permyriad;

    private String type;

    public RelativeDiscountValue build() {
      RelativeDiscountValue result = new RelativeDiscountValue();
      result.permyriad = this.permyriad;
      result.type = this.type;
      return result;
    }

    public Builder permyriad(Integer permyriad) {
      this.permyriad = permyriad;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
