package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RelativeDiscountValueInput {
  private Integer permyriad;

  public RelativeDiscountValueInput() {
  }

  public RelativeDiscountValueInput(Integer permyriad) {
    this.permyriad = permyriad;
  }

  public Integer getPermyriad() {
    return permyriad;
  }

  public void setPermyriad(Integer permyriad) {
    this.permyriad = permyriad;
  }

  @Override
  public String toString() {
    return "RelativeDiscountValueInput{permyriad='" + permyriad + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RelativeDiscountValueInput that = (RelativeDiscountValueInput) o;
    return Objects.equals(permyriad, that.permyriad);
  }

  @Override
  public int hashCode() {
    return Objects.hash(permyriad);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer permyriad;

    public RelativeDiscountValueInput build() {
      RelativeDiscountValueInput result = new RelativeDiscountValueInput();
      result.permyriad = this.permyriad;
      return result;
    }

    public Builder permyriad(Integer permyriad) {
      this.permyriad = permyriad;
      return this;
    }
  }
}
