package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveAssociateRolePermission {
  private Permission permission;

  public RemoveAssociateRolePermission() {
  }

  public RemoveAssociateRolePermission(Permission permission) {
    this.permission = permission;
  }

  public Permission getPermission() {
    return permission;
  }

  public void setPermission(Permission permission) {
    this.permission = permission;
  }

  @Override
  public String toString() {
    return "RemoveAssociateRolePermission{permission='" + permission + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveAssociateRolePermission that = (RemoveAssociateRolePermission) o;
    return Objects.equals(permission, that.permission);
  }

  @Override
  public int hashCode() {
    return Objects.hash(permission);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Permission permission;

    public RemoveAssociateRolePermission build() {
      RemoveAssociateRolePermission result = new RemoveAssociateRolePermission();
      result.permission = this.permission;
      return result;
    }

    public Builder permission(Permission permission) {
      this.permission = permission;
      return this;
    }
  }
}
