package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveBusinessUnitAddress {
  private String addressId;

  private String addressKey;

  public RemoveBusinessUnitAddress() {
  }

  public RemoveBusinessUnitAddress(String addressId, String addressKey) {
    this.addressId = addressId;
    this.addressKey = addressKey;
  }

  public String getAddressId() {
    return addressId;
  }

  public void setAddressId(String addressId) {
    this.addressId = addressId;
  }

  public String getAddressKey() {
    return addressKey;
  }

  public void setAddressKey(String addressKey) {
    this.addressKey = addressKey;
  }

  @Override
  public String toString() {
    return "RemoveBusinessUnitAddress{addressId='" + addressId + "', addressKey='" + addressKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveBusinessUnitAddress that = (RemoveBusinessUnitAddress) o;
    return Objects.equals(addressId, that.addressId) &&
        Objects.equals(addressKey, that.addressKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressId, addressKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String addressId;

    private String addressKey;

    public RemoveBusinessUnitAddress build() {
      RemoveBusinessUnitAddress result = new RemoveBusinessUnitAddress();
      result.addressId = this.addressId;
      result.addressKey = this.addressKey;
      return result;
    }

    public Builder addressId(String addressId) {
      this.addressId = addressId;
      return this;
    }

    public Builder addressKey(String addressKey) {
      this.addressKey = addressKey;
      return this;
    }
  }
}
