package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveCartCustomLineItem {
  private String customLineItemId;

  private String customLineItemKey;

  public RemoveCartCustomLineItem() {
  }

  public RemoveCartCustomLineItem(String customLineItemId, String customLineItemKey) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  @Override
  public String toString() {
    return "RemoveCartCustomLineItem{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveCartCustomLineItem that = (RemoveCartCustomLineItem) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    public RemoveCartCustomLineItem build() {
      RemoveCartCustomLineItem result = new RemoveCartCustomLineItem();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }
  }
}
