package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveCartDiscountCode {
  private ReferenceInput discountCode;

  public RemoveCartDiscountCode() {
  }

  public RemoveCartDiscountCode(ReferenceInput discountCode) {
    this.discountCode = discountCode;
  }

  public ReferenceInput getDiscountCode() {
    return discountCode;
  }

  public void setDiscountCode(ReferenceInput discountCode) {
    this.discountCode = discountCode;
  }

  @Override
  public String toString() {
    return "RemoveCartDiscountCode{discountCode='" + discountCode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveCartDiscountCode that = (RemoveCartDiscountCode) o;
    return Objects.equals(discountCode, that.discountCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discountCode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ReferenceInput discountCode;

    public RemoveCartDiscountCode build() {
      RemoveCartDiscountCode result = new RemoveCartDiscountCode();
      result.discountCode = this.discountCode;
      return result;
    }

    public Builder discountCode(ReferenceInput discountCode) {
      this.discountCode = discountCode;
      return this;
    }
  }
}
