package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveCartShippingMethod {
  private String shippingKey;

  public RemoveCartShippingMethod() {
  }

  public RemoveCartShippingMethod(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  @Override
  public String toString() {
    return "RemoveCartShippingMethod{shippingKey='" + shippingKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveCartShippingMethod that = (RemoveCartShippingMethod) o;
    return Objects.equals(shippingKey, that.shippingKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String shippingKey;

    public RemoveCartShippingMethod build() {
      RemoveCartShippingMethod result = new RemoveCartShippingMethod();
      result.shippingKey = this.shippingKey;
      return result;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }
  }
}
