package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveProductFromCategory {
  private ResourceIdentifierInput category;

  private Boolean staged = true;

  public RemoveProductFromCategory() {
  }

  public RemoveProductFromCategory(ResourceIdentifierInput category, Boolean staged) {
    this.category = category;
    this.staged = staged;
  }

  public ResourceIdentifierInput getCategory() {
    return category;
  }

  public void setCategory(ResourceIdentifierInput category) {
    this.category = category;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "RemoveProductFromCategory{category='" + category + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveProductFromCategory that = (RemoveProductFromCategory) o;
    return Objects.equals(category, that.category) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(category, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput category;

    private Boolean staged = true;

    public RemoveProductFromCategory build() {
      RemoveProductFromCategory result = new RemoveProductFromCategory();
      result.category = this.category;
      result.staged = this.staged;
      return result;
    }

    public Builder category(ResourceIdentifierInput category) {
      this.category = category;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
