package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveProductPrice {
  private String priceId;

  private Boolean staged = true;

  public RemoveProductPrice() {
  }

  public RemoveProductPrice(String priceId, Boolean staged) {
    this.priceId = priceId;
    this.staged = staged;
  }

  public String getPriceId() {
    return priceId;
  }

  public void setPriceId(String priceId) {
    this.priceId = priceId;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "RemoveProductPrice{priceId='" + priceId + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveProductPrice that = (RemoveProductPrice) o;
    return Objects.equals(priceId, that.priceId) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(priceId, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String priceId;

    private Boolean staged = true;

    public RemoveProductPrice build() {
      RemoveProductPrice result = new RemoveProductPrice();
      result.priceId = this.priceId;
      result.staged = this.staged;
      return result;
    }

    public Builder priceId(String priceId) {
      this.priceId = priceId;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
