package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveProductTailoringImage {
  private Integer variantId;

  private String sku;

  private String imageUrl;

  private Boolean staged = true;

  public RemoveProductTailoringImage() {
  }

  public RemoveProductTailoringImage(Integer variantId, String sku, String imageUrl,
      Boolean staged) {
    this.variantId = variantId;
    this.sku = sku;
    this.imageUrl = imageUrl;
    this.staged = staged;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getImageUrl() {
    return imageUrl;
  }

  public void setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "RemoveProductTailoringImage{variantId='" + variantId + "', sku='" + sku + "', imageUrl='" + imageUrl + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveProductTailoringImage that = (RemoveProductTailoringImage) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(imageUrl, that.imageUrl) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, sku, imageUrl, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String sku;

    private String imageUrl;

    private Boolean staged = true;

    public RemoveProductTailoringImage build() {
      RemoveProductTailoringImage result = new RemoveProductTailoringImage();
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.imageUrl = this.imageUrl;
      result.staged = this.staged;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder imageUrl(String imageUrl) {
      this.imageUrl = imageUrl;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
