package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveProductVariantTailoring {
  private Integer id;

  private String sku;

  private Boolean staged = true;

  public RemoveProductVariantTailoring() {
  }

  public RemoveProductVariantTailoring(Integer id, String sku, Boolean staged) {
    this.id = id;
    this.sku = sku;
    this.staged = staged;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "RemoveProductVariantTailoring{id='" + id + "', sku='" + sku + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveProductVariantTailoring that = (RemoveProductVariantTailoring) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, sku, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer id;

    private String sku;

    private Boolean staged = true;

    public RemoveProductVariantTailoring build() {
      RemoveProductVariantTailoring result = new RemoveProductVariantTailoring();
      result.id = this.id;
      result.sku = this.sku;
      result.staged = this.staged;
      return result;
    }

    public Builder id(Integer id) {
      this.id = id;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
