package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveShippingMethodZone {
  private ResourceIdentifierInput zone;

  public RemoveShippingMethodZone() {
  }

  public RemoveShippingMethodZone(ResourceIdentifierInput zone) {
    this.zone = zone;
  }

  public ResourceIdentifierInput getZone() {
    return zone;
  }

  public void setZone(ResourceIdentifierInput zone) {
    this.zone = zone;
  }

  @Override
  public String toString() {
    return "RemoveShippingMethodZone{zone='" + zone + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveShippingMethodZone that = (RemoveShippingMethodZone) o;
    return Objects.equals(zone, that.zone);
  }

  @Override
  public int hashCode() {
    return Objects.hash(zone);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput zone;

    public RemoveShippingMethodZone build() {
      RemoveShippingMethodZone result = new RemoveShippingMethodZone();
      result.zone = this.zone;
      return result;
    }

    public Builder zone(ResourceIdentifierInput zone) {
      this.zone = zone;
      return this;
    }
  }
}
