package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveShoppingListLineItem {
  private String lineItemId;

  private String lineItemKey;

  private Integer quantity;

  public RemoveShoppingListLineItem() {
  }

  public RemoveShoppingListLineItem(String lineItemId, String lineItemKey, Integer quantity) {
    this.lineItemId = lineItemId;
    this.lineItemKey = lineItemKey;
    this.quantity = quantity;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public Integer getQuantity() {
    return quantity;
  }

  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }

  @Override
  public String toString() {
    return "RemoveShoppingListLineItem{lineItemId='" + lineItemId + "', lineItemKey='" + lineItemKey + "', quantity='" + quantity + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveShoppingListLineItem that = (RemoveShoppingListLineItem) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(quantity, that.quantity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, lineItemKey, quantity);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private String lineItemKey;

    private Integer quantity;

    public RemoveShoppingListLineItem build() {
      RemoveShoppingListLineItem result = new RemoveShoppingListLineItem();
      result.lineItemId = this.lineItemId;
      result.lineItemKey = this.lineItemKey;
      result.quantity = this.quantity;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder quantity(Integer quantity) {
      this.quantity = quantity;
      return this;
    }
  }
}
