package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveStagedOrderDelivery {
  private String deliveryId;

  private String deliveryKey;

  public RemoveStagedOrderDelivery() {
  }

  public RemoveStagedOrderDelivery(String deliveryId, String deliveryKey) {
    this.deliveryId = deliveryId;
    this.deliveryKey = deliveryKey;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public String getDeliveryKey() {
    return deliveryKey;
  }

  public void setDeliveryKey(String deliveryKey) {
    this.deliveryKey = deliveryKey;
  }

  @Override
  public String toString() {
    return "RemoveStagedOrderDelivery{deliveryId='" + deliveryId + "', deliveryKey='" + deliveryKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStagedOrderDelivery that = (RemoveStagedOrderDelivery) o;
    return Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(deliveryKey, that.deliveryKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deliveryId, deliveryKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String deliveryId;

    private String deliveryKey;

    public RemoveStagedOrderDelivery build() {
      RemoveStagedOrderDelivery result = new RemoveStagedOrderDelivery();
      result.deliveryId = this.deliveryId;
      result.deliveryKey = this.deliveryKey;
      return result;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder deliveryKey(String deliveryKey) {
      this.deliveryKey = deliveryKey;
      return this;
    }
  }
}
