package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class RemoveStagedOrderDiscountCodeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private DiscountCode discountCode;

  private Reference discountCodeRef;

  private String type;

  public RemoveStagedOrderDiscountCodeOutput() {
  }

  public RemoveStagedOrderDiscountCodeOutput(DiscountCode discountCode, Reference discountCodeRef,
      String type) {
    this.discountCode = discountCode;
    this.discountCodeRef = discountCodeRef;
    this.type = type;
  }

  public DiscountCode getDiscountCode() {
    return discountCode;
  }

  public void setDiscountCode(DiscountCode discountCode) {
    this.discountCode = discountCode;
  }

  public Reference getDiscountCodeRef() {
    return discountCodeRef;
  }

  public void setDiscountCodeRef(Reference discountCodeRef) {
    this.discountCodeRef = discountCodeRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "RemoveStagedOrderDiscountCodeOutput{discountCode='" + discountCode + "', discountCodeRef='" + discountCodeRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStagedOrderDiscountCodeOutput that = (RemoveStagedOrderDiscountCodeOutput) o;
    return Objects.equals(discountCode, that.discountCode) &&
        Objects.equals(discountCodeRef, that.discountCodeRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discountCode, discountCodeRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private DiscountCode discountCode;

    private Reference discountCodeRef;

    private String type;

    public RemoveStagedOrderDiscountCodeOutput build() {
      RemoveStagedOrderDiscountCodeOutput result = new RemoveStagedOrderDiscountCodeOutput();
      result.discountCode = this.discountCode;
      result.discountCodeRef = this.discountCodeRef;
      result.type = this.type;
      return result;
    }

    public Builder discountCode(DiscountCode discountCode) {
      this.discountCode = discountCode;
      return this;
    }

    public Builder discountCodeRef(Reference discountCodeRef) {
      this.discountCodeRef = discountCodeRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
