package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class RemoveStagedOrderItemShippingAddressOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String addressKey;

  public RemoveStagedOrderItemShippingAddressOutput() {
  }

  public RemoveStagedOrderItemShippingAddressOutput(String type, String addressKey) {
    this.type = type;
    this.addressKey = addressKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getAddressKey() {
    return addressKey;
  }

  public void setAddressKey(String addressKey) {
    this.addressKey = addressKey;
  }

  @Override
  public String toString() {
    return "RemoveStagedOrderItemShippingAddressOutput{type='" + type + "', addressKey='" + addressKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStagedOrderItemShippingAddressOutput that = (RemoveStagedOrderItemShippingAddressOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(addressKey, that.addressKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, addressKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String addressKey;

    public RemoveStagedOrderItemShippingAddressOutput build() {
      RemoveStagedOrderItemShippingAddressOutput result = new RemoveStagedOrderItemShippingAddressOutput();
      result.type = this.type;
      result.addressKey = this.addressKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder addressKey(String addressKey) {
      this.addressKey = addressKey;
      return this;
    }
  }
}
