package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveStandalonePriceTier {
  private Integer minimumQuantity;

  public RemoveStandalonePriceTier() {
  }

  public RemoveStandalonePriceTier(Integer minimumQuantity) {
    this.minimumQuantity = minimumQuantity;
  }

  public Integer getMinimumQuantity() {
    return minimumQuantity;
  }

  public void setMinimumQuantity(Integer minimumQuantity) {
    this.minimumQuantity = minimumQuantity;
  }

  @Override
  public String toString() {
    return "RemoveStandalonePriceTier{minimumQuantity='" + minimumQuantity + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStandalonePriceTier that = (RemoveStandalonePriceTier) o;
    return Objects.equals(minimumQuantity, that.minimumQuantity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(minimumQuantity);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer minimumQuantity;

    public RemoveStandalonePriceTier build() {
      RemoveStandalonePriceTier result = new RemoveStandalonePriceTier();
      result.minimumQuantity = this.minimumQuantity;
      return result;
    }

    public Builder minimumQuantity(Integer minimumQuantity) {
      this.minimumQuantity = minimumQuantity;
      return this;
    }
  }
}
