package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveStoreCountry {
  private StoreCountryInput country;

  public RemoveStoreCountry() {
  }

  public RemoveStoreCountry(StoreCountryInput country) {
    this.country = country;
  }

  public StoreCountryInput getCountry() {
    return country;
  }

  public void setCountry(StoreCountryInput country) {
    this.country = country;
  }

  @Override
  public String toString() {
    return "RemoveStoreCountry{country='" + country + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStoreCountry that = (RemoveStoreCountry) o;
    return Objects.equals(country, that.country);
  }

  @Override
  public int hashCode() {
    return Objects.hash(country);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private StoreCountryInput country;

    public RemoveStoreCountry build() {
      RemoveStoreCountry result = new RemoveStoreCountry();
      result.country = this.country;
      return result;
    }

    public Builder country(StoreCountryInput country) {
      this.country = country;
      return this;
    }
  }
}
