package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveStoreDistributionChannel {
  private ResourceIdentifierInput distributionChannel;

  public RemoveStoreDistributionChannel() {
  }

  public RemoveStoreDistributionChannel(ResourceIdentifierInput distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  public ResourceIdentifierInput getDistributionChannel() {
    return distributionChannel;
  }

  public void setDistributionChannel(ResourceIdentifierInput distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  @Override
  public String toString() {
    return "RemoveStoreDistributionChannel{distributionChannel='" + distributionChannel + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStoreDistributionChannel that = (RemoveStoreDistributionChannel) o;
    return Objects.equals(distributionChannel, that.distributionChannel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(distributionChannel);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput distributionChannel;

    public RemoveStoreDistributionChannel build() {
      RemoveStoreDistributionChannel result = new RemoveStoreDistributionChannel();
      result.distributionChannel = this.distributionChannel;
      return result;
    }

    public Builder distributionChannel(ResourceIdentifierInput distributionChannel) {
      this.distributionChannel = distributionChannel;
      return this;
    }
  }
}
