package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveStoreProductSelection {
  private ResourceIdentifierInput productSelection;

  public RemoveStoreProductSelection() {
  }

  public RemoveStoreProductSelection(ResourceIdentifierInput productSelection) {
    this.productSelection = productSelection;
  }

  public ResourceIdentifierInput getProductSelection() {
    return productSelection;
  }

  public void setProductSelection(ResourceIdentifierInput productSelection) {
    this.productSelection = productSelection;
  }

  @Override
  public String toString() {
    return "RemoveStoreProductSelection{productSelection='" + productSelection + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStoreProductSelection that = (RemoveStoreProductSelection) o;
    return Objects.equals(productSelection, that.productSelection);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productSelection);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput productSelection;

    public RemoveStoreProductSelection build() {
      RemoveStoreProductSelection result = new RemoveStoreProductSelection();
      result.productSelection = this.productSelection;
      return result;
    }

    public Builder productSelection(ResourceIdentifierInput productSelection) {
      this.productSelection = productSelection;
      return this;
    }
  }
}
