package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveTypeFieldDefinition {
  private String fieldName;

  public RemoveTypeFieldDefinition() {
  }

  public RemoveTypeFieldDefinition(String fieldName) {
    this.fieldName = fieldName;
  }

  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  @Override
  public String toString() {
    return "RemoveTypeFieldDefinition{fieldName='" + fieldName + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveTypeFieldDefinition that = (RemoveTypeFieldDefinition) o;
    return Objects.equals(fieldName, that.fieldName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldName);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String fieldName;

    public RemoveTypeFieldDefinition build() {
      RemoveTypeFieldDefinition result = new RemoveTypeFieldDefinition();
      result.fieldName = this.fieldName;
      return result;
    }

    public Builder fieldName(String fieldName) {
      this.fieldName = fieldName;
      return this;
    }
  }
}
