package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveZoneLocation {
  private ZoneLocation location;

  public RemoveZoneLocation() {
  }

  public RemoveZoneLocation(ZoneLocation location) {
    this.location = location;
  }

  public ZoneLocation getLocation() {
    return location;
  }

  public void setLocation(ZoneLocation location) {
    this.location = location;
  }

  @Override
  public String toString() {
    return "RemoveZoneLocation{location='" + location + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveZoneLocation that = (RemoveZoneLocation) o;
    return Objects.equals(location, that.location);
  }

  @Override
  public int hashCode() {
    return Objects.hash(location);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ZoneLocation location;

    public RemoveZoneLocation build() {
      RemoveZoneLocation result = new RemoveZoneLocation();
      result.location = this.location;
      return result;
    }

    public Builder location(ZoneLocation location) {
      this.location = location;
      return this;
    }
  }
}
