package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 * Stores information about returns connected to this order.
 */
public class ReturnInfo {
  private List<ReturnItem> items;

  private String returnTrackingId;

  private OffsetDateTime returnDate;

  public ReturnInfo() {
  }

  public ReturnInfo(List<ReturnItem> items, String returnTrackingId, OffsetDateTime returnDate) {
    this.items = items;
    this.returnTrackingId = returnTrackingId;
    this.returnDate = returnDate;
  }

  public List<ReturnItem> getItems() {
    return items;
  }

  public void setItems(List<ReturnItem> items) {
    this.items = items;
  }

  public String getReturnTrackingId() {
    return returnTrackingId;
  }

  public void setReturnTrackingId(String returnTrackingId) {
    this.returnTrackingId = returnTrackingId;
  }

  public OffsetDateTime getReturnDate() {
    return returnDate;
  }

  public void setReturnDate(OffsetDateTime returnDate) {
    this.returnDate = returnDate;
  }

  @Override
  public String toString() {
    return "ReturnInfo{items='" + items + "', returnTrackingId='" + returnTrackingId + "', returnDate='" + returnDate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReturnInfo that = (ReturnInfo) o;
    return Objects.equals(items, that.items) &&
        Objects.equals(returnTrackingId, that.returnTrackingId) &&
        Objects.equals(returnDate, that.returnDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(items, returnTrackingId, returnDate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ReturnItem> items;

    private String returnTrackingId;

    private OffsetDateTime returnDate;

    public ReturnInfo build() {
      ReturnInfo result = new ReturnInfo();
      result.items = this.items;
      result.returnTrackingId = this.returnTrackingId;
      result.returnDate = this.returnDate;
      return result;
    }

    public Builder items(List<ReturnItem> items) {
      this.items = items;
      return this;
    }

    public Builder returnTrackingId(String returnTrackingId) {
      this.returnTrackingId = returnTrackingId;
      return this;
    }

    public Builder returnDate(OffsetDateTime returnDate) {
      this.returnDate = returnDate;
      return this;
    }
  }
}
