package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.String;
import java.time.OffsetDateTime;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = CustomLineItemReturnItem.class, name = "CustomLineItemReturnItem"),
    @JsonSubTypes.Type(value = LineItemReturnItem.class, name = "LineItemReturnItem")
})
public interface ReturnItem {
  String getType();

  void setType(String type);

  String getId();

  void setId(String id);

  String getKey();

  void setKey(String key);

  Long getQuantity();

  void setQuantity(Long quantity);

  String getComment();

  void setComment(String comment);

  ReturnShipmentState getShipmentState();

  void setShipmentState(ReturnShipmentState shipmentState);

  ReturnPaymentState getPaymentState();

  void setPaymentState(ReturnPaymentState paymentState);

  CustomFieldsType getCustom();

  void setCustom(CustomFieldsType custom);

  OffsetDateTime getLastModifiedAt();

  void setLastModifiedAt(OffsetDateTime lastModifiedAt);

  OffsetDateTime getCreatedAt();

  void setCreatedAt(OffsetDateTime createdAt);
}
