package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RevertStagedVariantChanges {
  private Integer variantId;

  public RevertStagedVariantChanges() {
  }

  public RevertStagedVariantChanges(Integer variantId) {
    this.variantId = variantId;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  @Override
  public String toString() {
    return "RevertStagedVariantChanges{variantId='" + variantId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RevertStagedVariantChanges that = (RevertStagedVariantChanges) o;
    return Objects.equals(variantId, that.variantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    public RevertStagedVariantChanges build() {
      RevertStagedVariantChanges result = new RevertStagedVariantChanges();
      result.variantId = this.variantId;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }
  }
}
