package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ReviewDraft {
  private String key;

  private String uniquenessValue;

  private String locale;

  private String authorName;

  private String title;

  private String text;

  private TargetReferenceInput target;

  private ResourceIdentifierInput state;

  private Integer rating;

  private ResourceIdentifierInput customer;

  private CustomFieldsDraft custom;

  public ReviewDraft() {
  }

  public ReviewDraft(String key, String uniquenessValue, String locale, String authorName,
      String title, String text, TargetReferenceInput target, ResourceIdentifierInput state,
      Integer rating, ResourceIdentifierInput customer, CustomFieldsDraft custom) {
    this.key = key;
    this.uniquenessValue = uniquenessValue;
    this.locale = locale;
    this.authorName = authorName;
    this.title = title;
    this.text = text;
    this.target = target;
    this.state = state;
    this.rating = rating;
    this.customer = customer;
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getUniquenessValue() {
    return uniquenessValue;
  }

  public void setUniquenessValue(String uniquenessValue) {
    this.uniquenessValue = uniquenessValue;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public String getAuthorName() {
    return authorName;
  }

  public void setAuthorName(String authorName) {
    this.authorName = authorName;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }

  public TargetReferenceInput getTarget() {
    return target;
  }

  public void setTarget(TargetReferenceInput target) {
    this.target = target;
  }

  public ResourceIdentifierInput getState() {
    return state;
  }

  public void setState(ResourceIdentifierInput state) {
    this.state = state;
  }

  public Integer getRating() {
    return rating;
  }

  public void setRating(Integer rating) {
    this.rating = rating;
  }

  public ResourceIdentifierInput getCustomer() {
    return customer;
  }

  public void setCustomer(ResourceIdentifierInput customer) {
    this.customer = customer;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "ReviewDraft{key='" + key + "', uniquenessValue='" + uniquenessValue + "', locale='" + locale + "', authorName='" + authorName + "', title='" + title + "', text='" + text + "', target='" + target + "', state='" + state + "', rating='" + rating + "', customer='" + customer + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReviewDraft that = (ReviewDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(uniquenessValue, that.uniquenessValue) &&
        Objects.equals(locale, that.locale) &&
        Objects.equals(authorName, that.authorName) &&
        Objects.equals(title, that.title) &&
        Objects.equals(text, that.text) &&
        Objects.equals(target, that.target) &&
        Objects.equals(state, that.state) &&
        Objects.equals(rating, that.rating) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, uniquenessValue, locale, authorName, title, text, target, state, rating, customer, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String uniquenessValue;

    private String locale;

    private String authorName;

    private String title;

    private String text;

    private TargetReferenceInput target;

    private ResourceIdentifierInput state;

    private Integer rating;

    private ResourceIdentifierInput customer;

    private CustomFieldsDraft custom;

    public ReviewDraft build() {
      ReviewDraft result = new ReviewDraft();
      result.key = this.key;
      result.uniquenessValue = this.uniquenessValue;
      result.locale = this.locale;
      result.authorName = this.authorName;
      result.title = this.title;
      result.text = this.text;
      result.target = this.target;
      result.state = this.state;
      result.rating = this.rating;
      result.customer = this.customer;
      result.custom = this.custom;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder uniquenessValue(String uniquenessValue) {
      this.uniquenessValue = uniquenessValue;
      return this;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder authorName(String authorName) {
      this.authorName = authorName;
      return this;
    }

    public Builder title(String title) {
      this.title = title;
      return this;
    }

    public Builder text(String text) {
      this.text = text;
      return this;
    }

    public Builder target(TargetReferenceInput target) {
      this.target = target;
      return this;
    }

    public Builder state(ResourceIdentifierInput state) {
      this.state = state;
      return this;
    }

    public Builder rating(Integer rating) {
      this.rating = rating;
      return this;
    }

    public Builder customer(ResourceIdentifierInput customer) {
      this.customer = customer;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
