package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ReviewStateTransition implements com.commercetools.graphql.api.types.MessagePayload {
  private Boolean oldIncludedInStatistics;

  private Boolean newIncludedInStatistics;

  private Boolean force;

  private ReviewTarget target;

  private State oldState;

  private State newState;

  private Reference targetRef;

  private Reference oldStateRef;

  private Reference newStateRef;

  private String type;

  public ReviewStateTransition() {
  }

  public ReviewStateTransition(Boolean oldIncludedInStatistics, Boolean newIncludedInStatistics,
      Boolean force, ReviewTarget target, State oldState, State newState, Reference targetRef,
      Reference oldStateRef, Reference newStateRef, String type) {
    this.oldIncludedInStatistics = oldIncludedInStatistics;
    this.newIncludedInStatistics = newIncludedInStatistics;
    this.force = force;
    this.target = target;
    this.oldState = oldState;
    this.newState = newState;
    this.targetRef = targetRef;
    this.oldStateRef = oldStateRef;
    this.newStateRef = newStateRef;
    this.type = type;
  }

  public Boolean getOldIncludedInStatistics() {
    return oldIncludedInStatistics;
  }

  public void setOldIncludedInStatistics(Boolean oldIncludedInStatistics) {
    this.oldIncludedInStatistics = oldIncludedInStatistics;
  }

  public Boolean getNewIncludedInStatistics() {
    return newIncludedInStatistics;
  }

  public void setNewIncludedInStatistics(Boolean newIncludedInStatistics) {
    this.newIncludedInStatistics = newIncludedInStatistics;
  }

  public Boolean getForce() {
    return force;
  }

  public void setForce(Boolean force) {
    this.force = force;
  }

  public ReviewTarget getTarget() {
    return target;
  }

  public void setTarget(ReviewTarget target) {
    this.target = target;
  }

  public State getOldState() {
    return oldState;
  }

  public void setOldState(State oldState) {
    this.oldState = oldState;
  }

  public State getNewState() {
    return newState;
  }

  public void setNewState(State newState) {
    this.newState = newState;
  }

  public Reference getTargetRef() {
    return targetRef;
  }

  public void setTargetRef(Reference targetRef) {
    this.targetRef = targetRef;
  }

  public Reference getOldStateRef() {
    return oldStateRef;
  }

  public void setOldStateRef(Reference oldStateRef) {
    this.oldStateRef = oldStateRef;
  }

  public Reference getNewStateRef() {
    return newStateRef;
  }

  public void setNewStateRef(Reference newStateRef) {
    this.newStateRef = newStateRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ReviewStateTransition{oldIncludedInStatistics='" + oldIncludedInStatistics + "', newIncludedInStatistics='" + newIncludedInStatistics + "', force='" + force + "', target='" + target + "', oldState='" + oldState + "', newState='" + newState + "', targetRef='" + targetRef + "', oldStateRef='" + oldStateRef + "', newStateRef='" + newStateRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReviewStateTransition that = (ReviewStateTransition) o;
    return Objects.equals(oldIncludedInStatistics, that.oldIncludedInStatistics) &&
        Objects.equals(newIncludedInStatistics, that.newIncludedInStatistics) &&
        Objects.equals(force, that.force) &&
        Objects.equals(target, that.target) &&
        Objects.equals(oldState, that.oldState) &&
        Objects.equals(newState, that.newState) &&
        Objects.equals(targetRef, that.targetRef) &&
        Objects.equals(oldStateRef, that.oldStateRef) &&
        Objects.equals(newStateRef, that.newStateRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldIncludedInStatistics, newIncludedInStatistics, force, target, oldState, newState, targetRef, oldStateRef, newStateRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean oldIncludedInStatistics;

    private Boolean newIncludedInStatistics;

    private Boolean force;

    private ReviewTarget target;

    private State oldState;

    private State newState;

    private Reference targetRef;

    private Reference oldStateRef;

    private Reference newStateRef;

    private String type;

    public ReviewStateTransition build() {
      ReviewStateTransition result = new ReviewStateTransition();
      result.oldIncludedInStatistics = this.oldIncludedInStatistics;
      result.newIncludedInStatistics = this.newIncludedInStatistics;
      result.force = this.force;
      result.target = this.target;
      result.oldState = this.oldState;
      result.newState = this.newState;
      result.targetRef = this.targetRef;
      result.oldStateRef = this.oldStateRef;
      result.newStateRef = this.newStateRef;
      result.type = this.type;
      return result;
    }

    public Builder oldIncludedInStatistics(Boolean oldIncludedInStatistics) {
      this.oldIncludedInStatistics = oldIncludedInStatistics;
      return this;
    }

    public Builder newIncludedInStatistics(Boolean newIncludedInStatistics) {
      this.newIncludedInStatistics = newIncludedInStatistics;
      return this;
    }

    public Builder force(Boolean force) {
      this.force = force;
      return this;
    }

    public Builder target(ReviewTarget target) {
      this.target = target;
      return this;
    }

    public Builder oldState(State oldState) {
      this.oldState = oldState;
      return this;
    }

    public Builder newState(State newState) {
      this.newState = newState;
      return this;
    }

    public Builder targetRef(Reference targetRef) {
      this.targetRef = targetRef;
      return this;
    }

    public Builder oldStateRef(Reference oldStateRef) {
      this.oldStateRef = oldStateRef;
      return this;
    }

    public Builder newStateRef(Reference newStateRef) {
      this.newStateRef = newStateRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
