package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SNSDestination implements com.commercetools.graphql.api.types.Destination {
  private String topicArn;

  private String accessKey;

  private String accessSecret;

  private AwsAuthenticationMode authenticationMode;

  private String type;

  public SNSDestination() {
  }

  public SNSDestination(String topicArn, String accessKey, String accessSecret,
      AwsAuthenticationMode authenticationMode, String type) {
    this.topicArn = topicArn;
    this.accessKey = accessKey;
    this.accessSecret = accessSecret;
    this.authenticationMode = authenticationMode;
    this.type = type;
  }

  public String getTopicArn() {
    return topicArn;
  }

  public void setTopicArn(String topicArn) {
    this.topicArn = topicArn;
  }

  public String getAccessKey() {
    return accessKey;
  }

  public void setAccessKey(String accessKey) {
    this.accessKey = accessKey;
  }

  public String getAccessSecret() {
    return accessSecret;
  }

  public void setAccessSecret(String accessSecret) {
    this.accessSecret = accessSecret;
  }

  public AwsAuthenticationMode getAuthenticationMode() {
    return authenticationMode;
  }

  public void setAuthenticationMode(AwsAuthenticationMode authenticationMode) {
    this.authenticationMode = authenticationMode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "SNSDestination{topicArn='" + topicArn + "', accessKey='" + accessKey + "', accessSecret='" + accessSecret + "', authenticationMode='" + authenticationMode + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SNSDestination that = (SNSDestination) o;
    return Objects.equals(topicArn, that.topicArn) &&
        Objects.equals(accessKey, that.accessKey) &&
        Objects.equals(accessSecret, that.accessSecret) &&
        Objects.equals(authenticationMode, that.authenticationMode) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(topicArn, accessKey, accessSecret, authenticationMode, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String topicArn;

    private String accessKey;

    private String accessSecret;

    private AwsAuthenticationMode authenticationMode;

    private String type;

    public SNSDestination build() {
      SNSDestination result = new SNSDestination();
      result.topicArn = this.topicArn;
      result.accessKey = this.accessKey;
      result.accessSecret = this.accessSecret;
      result.authenticationMode = this.authenticationMode;
      result.type = this.type;
      return result;
    }

    public Builder topicArn(String topicArn) {
      this.topicArn = topicArn;
      return this;
    }

    public Builder accessKey(String accessKey) {
      this.accessKey = accessKey;
      return this;
    }

    public Builder accessSecret(String accessSecret) {
      this.accessSecret = accessSecret;
      return this;
    }

    public Builder authenticationMode(AwsAuthenticationMode authenticationMode) {
      this.authenticationMode = authenticationMode;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
