package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SQSDestination implements com.commercetools.graphql.api.types.Destination {
  private String queueUrl;

  private String accessKey;

  private String accessSecret;

  private String region;

  private AwsAuthenticationMode authenticationMode;

  private String type;

  public SQSDestination() {
  }

  public SQSDestination(String queueUrl, String accessKey, String accessSecret, String region,
      AwsAuthenticationMode authenticationMode, String type) {
    this.queueUrl = queueUrl;
    this.accessKey = accessKey;
    this.accessSecret = accessSecret;
    this.region = region;
    this.authenticationMode = authenticationMode;
    this.type = type;
  }

  public String getQueueUrl() {
    return queueUrl;
  }

  public void setQueueUrl(String queueUrl) {
    this.queueUrl = queueUrl;
  }

  public String getAccessKey() {
    return accessKey;
  }

  public void setAccessKey(String accessKey) {
    this.accessKey = accessKey;
  }

  public String getAccessSecret() {
    return accessSecret;
  }

  public void setAccessSecret(String accessSecret) {
    this.accessSecret = accessSecret;
  }

  public String getRegion() {
    return region;
  }

  public void setRegion(String region) {
    this.region = region;
  }

  public AwsAuthenticationMode getAuthenticationMode() {
    return authenticationMode;
  }

  public void setAuthenticationMode(AwsAuthenticationMode authenticationMode) {
    this.authenticationMode = authenticationMode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "SQSDestination{queueUrl='" + queueUrl + "', accessKey='" + accessKey + "', accessSecret='" + accessSecret + "', region='" + region + "', authenticationMode='" + authenticationMode + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SQSDestination that = (SQSDestination) o;
    return Objects.equals(queueUrl, that.queueUrl) &&
        Objects.equals(accessKey, that.accessKey) &&
        Objects.equals(accessSecret, that.accessSecret) &&
        Objects.equals(region, that.region) &&
        Objects.equals(authenticationMode, that.authenticationMode) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(queueUrl, accessKey, accessSecret, region, authenticationMode, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String queueUrl;

    private String accessKey;

    private String accessSecret;

    private String region;

    private AwsAuthenticationMode authenticationMode;

    private String type;

    public SQSDestination build() {
      SQSDestination result = new SQSDestination();
      result.queueUrl = this.queueUrl;
      result.accessKey = this.accessKey;
      result.accessSecret = this.accessSecret;
      result.region = this.region;
      result.authenticationMode = this.authenticationMode;
      result.type = this.type;
      return result;
    }

    public Builder queueUrl(String queueUrl) {
      this.queueUrl = queueUrl;
      return this;
    }

    public Builder accessKey(String accessKey) {
      this.accessKey = accessKey;
      return this;
    }

    public Builder accessSecret(String accessSecret) {
      this.accessSecret = accessSecret;
      return this;
    }

    public Builder region(String region) {
      this.region = region;
      return this;
    }

    public Builder authenticationMode(AwsAuthenticationMode authenticationMode) {
      this.authenticationMode = authenticationMode;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
