package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ScoreShippingRateInputDraft {
  private Integer score;

  public ScoreShippingRateInputDraft() {
  }

  public ScoreShippingRateInputDraft(Integer score) {
    this.score = score;
  }

  public Integer getScore() {
    return score;
  }

  public void setScore(Integer score) {
    this.score = score;
  }

  @Override
  public String toString() {
    return "ScoreShippingRateInputDraft{score='" + score + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ScoreShippingRateInputDraft that = (ScoreShippingRateInputDraft) o;
    return Objects.equals(score, that.score);
  }

  @Override
  public int hashCode() {
    return Objects.hash(score);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer score;

    public ScoreShippingRateInputDraft build() {
      ScoreShippingRateInputDraft result = new ScoreShippingRateInputDraft();
      result.score = this.score;
      return result;
    }

    public Builder score(Integer score) {
      this.score = score;
      return this;
    }
  }
}
