package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SearchFilterInput {
  private SearchFilterModelInput model;

  private String string;

  public SearchFilterInput() {
  }

  public SearchFilterInput(SearchFilterModelInput model, String string) {
    this.model = model;
    this.string = string;
  }

  public SearchFilterModelInput getModel() {
    return model;
  }

  public void setModel(SearchFilterModelInput model) {
    this.model = model;
  }

  public String getString() {
    return string;
  }

  public void setString(String string) {
    this.string = string;
  }

  @Override
  public String toString() {
    return "SearchFilterInput{model='" + model + "', string='" + string + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchFilterInput that = (SearchFilterInput) o;
    return Objects.equals(model, that.model) &&
        Objects.equals(string, that.string);
  }

  @Override
  public int hashCode() {
    return Objects.hash(model, string);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private SearchFilterModelInput model;

    private String string;

    public SearchFilterInput build() {
      SearchFilterInput result = new SearchFilterInput();
      result.model = this.model;
      result.string = this.string;
      return result;
    }

    public Builder model(SearchFilterModelInput model) {
      this.model = model;
      return this;
    }

    public Builder string(String string) {
      this.string = string;
      return this;
    }
  }
}
