package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SearchIndexingConfiguration {
  private SearchIndexingConfigurationValues products;

  private OrderSearchConfiguration orders;

  private CustomerSearchConfiguration customers;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private BusinessUnitSearchConfiguration businessUnits;

  public SearchIndexingConfiguration() {
  }

  public SearchIndexingConfiguration(SearchIndexingConfigurationValues products,
      OrderSearchConfiguration orders, CustomerSearchConfiguration customers,
      BusinessUnitSearchConfiguration businessUnits) {
    this.products = products;
    this.orders = orders;
    this.customers = customers;
    this.businessUnits = businessUnits;
  }

  public SearchIndexingConfigurationValues getProducts() {
    return products;
  }

  public void setProducts(SearchIndexingConfigurationValues products) {
    this.products = products;
  }

  public OrderSearchConfiguration getOrders() {
    return orders;
  }

  public void setOrders(OrderSearchConfiguration orders) {
    this.orders = orders;
  }

  public CustomerSearchConfiguration getCustomers() {
    return customers;
  }

  public void setCustomers(CustomerSearchConfiguration customers) {
    this.customers = customers;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public BusinessUnitSearchConfiguration getBusinessUnits() {
    return businessUnits;
  }

  public void setBusinessUnits(BusinessUnitSearchConfiguration businessUnits) {
    this.businessUnits = businessUnits;
  }

  @Override
  public String toString() {
    return "SearchIndexingConfiguration{products='" + products + "', orders='" + orders + "', customers='" + customers + "', businessUnits='" + businessUnits + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchIndexingConfiguration that = (SearchIndexingConfiguration) o;
    return Objects.equals(products, that.products) &&
        Objects.equals(orders, that.orders) &&
        Objects.equals(customers, that.customers) &&
        Objects.equals(businessUnits, that.businessUnits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(products, orders, customers, businessUnits);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private SearchIndexingConfigurationValues products;

    private OrderSearchConfiguration orders;

    private CustomerSearchConfiguration customers;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private BusinessUnitSearchConfiguration businessUnits;

    public SearchIndexingConfiguration build() {
      SearchIndexingConfiguration result = new SearchIndexingConfiguration();
      result.products = this.products;
      result.orders = this.orders;
      result.customers = this.customers;
      result.businessUnits = this.businessUnits;
      return result;
    }

    public Builder products(SearchIndexingConfigurationValues products) {
      this.products = products;
      return this;
    }

    public Builder orders(OrderSearchConfiguration orders) {
      this.orders = orders;
      return this;
    }

    public Builder customers(CustomerSearchConfiguration customers) {
      this.customers = customers;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder businessUnits(BusinessUnitSearchConfiguration businessUnits) {
      this.businessUnits = businessUnits;
      return this;
    }
  }
}
