package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SearchKeyword {
  private String text;

  private SuggestTokenizer suggestTokenizer;

  public SearchKeyword() {
  }

  public SearchKeyword(String text, SuggestTokenizer suggestTokenizer) {
    this.text = text;
    this.suggestTokenizer = suggestTokenizer;
  }

  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }

  public SuggestTokenizer getSuggestTokenizer() {
    return suggestTokenizer;
  }

  public void setSuggestTokenizer(SuggestTokenizer suggestTokenizer) {
    this.suggestTokenizer = suggestTokenizer;
  }

  @Override
  public String toString() {
    return "SearchKeyword{text='" + text + "', suggestTokenizer='" + suggestTokenizer + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchKeyword that = (SearchKeyword) o;
    return Objects.equals(text, that.text) &&
        Objects.equals(suggestTokenizer, that.suggestTokenizer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(text, suggestTokenizer);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String text;

    private SuggestTokenizer suggestTokenizer;

    public SearchKeyword build() {
      SearchKeyword result = new SearchKeyword();
      result.text = this.text;
      result.suggestTokenizer = this.suggestTokenizer;
      return result;
    }

    public Builder text(String text) {
      this.text = text;
      return this;
    }

    public Builder suggestTokenizer(SuggestTokenizer suggestTokenizer) {
      this.suggestTokenizer = suggestTokenizer;
      return this;
    }
  }
}
