package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SearchKeywordInput {
  private String locale;

  private List<SearchKeywordItemInput> keywords;

  public SearchKeywordInput() {
  }

  public SearchKeywordInput(String locale, List<SearchKeywordItemInput> keywords) {
    this.locale = locale;
    this.keywords = keywords;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public List<SearchKeywordItemInput> getKeywords() {
    return keywords;
  }

  public void setKeywords(List<SearchKeywordItemInput> keywords) {
    this.keywords = keywords;
  }

  @Override
  public String toString() {
    return "SearchKeywordInput{locale='" + locale + "', keywords='" + keywords + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchKeywordInput that = (SearchKeywordInput) o;
    return Objects.equals(locale, that.locale) &&
        Objects.equals(keywords, that.keywords);
  }

  @Override
  public int hashCode() {
    return Objects.hash(locale, keywords);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String locale;

    private List<SearchKeywordItemInput> keywords;

    public SearchKeywordInput build() {
      SearchKeywordInput result = new SearchKeywordInput();
      result.locale = this.locale;
      result.keywords = this.keywords;
      return result;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder keywords(List<SearchKeywordItemInput> keywords) {
      this.keywords = keywords;
      return this;
    }
  }
}
